<?php
/*--------------------------------------------------------------------------------------------------
    OnGetSelectedQuantityEventInterface.php 2020-03-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces;

use Exception;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Interfaces\QuantityInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\QuantityGraduation;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SelectedQuantity;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitStockInterface;

interface OnGetSelectedQuantityEventInterface extends BasicSellingUnitEventInterface
{
    /**
     * @return SelectedQuantity
     */
    public function selectedQuantity() : SelectedQuantity;
    
    
    /**
     * @param SelectedQuantity $quantity
     */
    public function setSelectedQuantity(SelectedQuantity $quantity) :void;
    
    
    /**
     * @return SelectedQuantity
     */
    public function requestedQuantity() : SelectedQuantity;

    /**
     * @return QuantityGraduation
     */
    public function quantityGraduation(): QuantityGraduation;

    /**
     * @return SellingUnitStockInterface
     */
    public function stock(): SellingUnitStockInterface;


    
}